﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace QueriesAndExpressions
{
    class Program
    {
        // Listing 8-1. Wyliczanie nazw plików.
        static IEnumerable<string> GetAllFilesInDirectory(string directoryPath)
        {
            return Directory.EnumerateFiles(directoryPath, "*",
                SearchOption.AllDirectories);
        }

        static void ShowBigFilesUsingQueryExpression()
        {
            // Listing 8-2. Zapytanie LINQ operujące na enumeracji.
            var bigFiles = from file in GetAllFilesInDirectory(@"c:\")
                           where new FileInfo(file).Length > 10000000
                           select file;
            foreach (string file in bigFiles)
            {
                Console.WriteLine(file);
            }
        }

        static void ShowBigFilesUsingMethodCalls()
        {
            // Listing 8-3. Zapytanie LINQ jako wywołania metod.
            var bigFiles = GetAllFilesInDirectory(@"c:\").
                Where(file => new FileInfo(file).Length > 10000000);

            foreach (string file in bigFiles)
            {
                Console.WriteLine(file);
            }
        }

        static void ShowBigFilesUsingMethodCallsWithSelect()
        {
            // Listing 8-4. Where i Slect jako metody.
            var bigFiles = GetAllFilesInDirectory(@"c:\").
                Where(file => new FileInfo(file).Length > 10000000).
                Select(file => "Plik: " + file);

            foreach (string file in bigFiles)
            {
                Console.WriteLine(file);
            }
        }

        static void Main(string[] args)
        {
            ShowBigFilesUsingQueryExpression();
            ShowBigFilesUsingMethodCalls();
            ShowBigFilesUsingMethodCallsWithSelect();
        }
    }
}
